﻿using System;
using Sitecore.Configuration;
using Sitecore.Data;
using Smartling.Connector.Model;
using Smartling.Connector.Translation;
using System.Linq;
using System.Web;
using Smartling.Connector.Diagnostics;
using Smartling.Connector.Translation.Profile;
using Smartling.Connector.Translation.Status;
using System.Collections.Generic;
using Newtonsoft.Json;
using Smartling.Connector.Extensions;

namespace Smartling.Connector.Shell
{
  /// <summary>
  /// Summary description for Status
  /// </summary>
  public class Status : IHttpHandler
  {
    private const string ItemIdParameter = "itemId";
    private const string TargetLanguageParameter = "targetLanguage";
    private const string ResponseFormatString = "{{\"complete\": {0}, \"wordCount\": {1}}}";
    private const string JsonContentType = "application/json";

    public void ProcessRequest(HttpContext context)
    {
      try
      {
        GetTranslationStatus(context);
      }
      catch (Exception ex)
      {
        SmartlingLogger.Log.Error(string.Format("Status.ashx failed to get status for item {0}\r\n{1}", HttpContext.Current.Request[ItemIdParameter], ex));
      }
    }

    private static void GetTranslationStatus(HttpContext context)
    {
      var queue = new TranslationQueue();
      ID itemId;
      if (!ID.TryParse(HttpContext.Current.Request[ItemIdParameter], out itemId))
      {
        return;
      }

      var db = Database.GetDatabase(ModuleConstants.DefaultDatabase);
      var item = db.GetItem(itemId);
      if (item == null)
      {
        return;
      }

      var profileService = new ProfileService();
      var profile = profileService.GetProfile(item);
      if (profile == null)
      {
        return;
      }

      var queuedItems = queue.GetAllItems(itemId, profile.SourceLanguage).ToList();
      if (!queuedItems.Any())
      {
        return;
      }

      var queuedItem = queuedItems.OrderByDescending(x => x.Created).First(x => !x.MediaContent);
      var statusManager = new StatusManager(queue, db, profileService);
      var fileStatus = statusManager.GetFileStatus(queuedItem.AsTranslationRequest(), profile.GetFileApiClient());

      var statusResponse = new List<LanguageStatus>();
      foreach (var languageItem in queuedItems)
      {
        var fileStatusItem = statusManager.UpdateLanguageStatus(profile, languageItem, fileStatus);
        statusResponse.Add(new LanguageStatus() { 
          TargetLanguage = languageItem.TargetLanguage,
          PercentComplete = languageItem.PercentComplete,
          WordCount = fileStatusItem.authorizedWordCount });
      }

      context.Response.ContentType = JsonContentType;
      context.Response.Write(JsonConvert.SerializeObject(statusResponse));
    }

    public bool IsReusable
    {
      get { return false; }
    }
  }
}
